<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 24.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Terminal');
requireLogin();
requireRole(['Bediener', 'Bearbeiter', 'Administrator']);
initializeDatabaseConnection();
showSessionAlert();

if (!isset($_SESSION['ID']) || !isset($_GET['id'])) {
    createSessionAlert("", "Ungültige Anfrage.", "error", "false", "2000");
    header('Location: /terminal/login');
    exit;
}

$zoneName = getZoneDetails($_GET['id'], 'ZoneName');

if (empty($zoneName)) {
    createSessionAlert("", "Ungültige Anfrage.", "error", "false", "2000");
    header('Location: /terminal/login');
    exit;
}

$session_id = $_SESSION['ID'];
$zone_id = $_GET['id'];
$_SESSION['currentTerminal'] = $zone_id;

try {

    $sql = "
        SELECT COUNT(*)
        FROM ZonePermissions
        WHERE (AccountID = :session_id AND ZoneID = :zone_id)
        OR EXISTS (
            SELECT 1
            FROM Accounts
            WHERE ID = :session_id
                AND Role IN ('Administrator', 'Bearbeiter')
        )
        ";

    // Abfrage vorbereiten
    $stmt = $pdo->prepare($sql);

    // Parameter binden
    $stmt->bindParam(':session_id', $session_id, PDO::PARAM_INT);
    $stmt->bindParam(':zone_id', $zone_id, PDO::PARAM_INT);

    // Abfrage ausführen
    $stmt->execute();

    // Ergebnis abrufen
    $permission_exists = $stmt->fetchColumn();

    // Berechtigung prüfen
    if (!$permission_exists) {
        createSessionAlert("", "Keine Berechtigung für diese Zone.", "error", "false", "2000");
        header('Location: /terminal/login');
        exit;
    }

} catch (PDOException $e) {
    echo 'Datenbankfehler: ' . $e->getMessage();
}

if (getZoneDetails($_GET['id'], 'AlarmAuthorisation') == '1') {

    // Alarm deaktivieren
    if (isset($_POST['setAlarmOff'])) {
        updateDBEntry('SystemOptions', 'Option', 'AlarmStatus', 'Value', 'false');
        addAuditLog($_SESSION['Username'], 'Alarm', 'Alarmierung deaktiviert');
        createSessionAlert("", "Alarm wurde deaktiviert", "success", "false", "2000");
        header('Location: /terminal/console?id=' . $_GET['id']);
        exit;
    }

    // Alarm aktivieren
    if (isset($_POST['setAlarm'])) {
        $alarmTypes = [
            'IDF' => ['INCOMING', "Incoming, Incoming, Incoming.\nSuchen Sie den nächstgelegenen Shelter auf."],
            'STIDF' => ['SIRENENTEST', "Es besteht kein Handlungsbedarf.\n\nIncoming, Incoming, Incoming.\nSuchen Sie den nächstgelegenen Shelter auf."],
            'EIDF' => ['EXERCISE', "Es besteht Handlungsbedarf.\n\nIncoming, Incoming, Incoming.\nSuchen Sie den nächstgelegenen Shelter auf."],
            'INTRUDER' => ['INTRUDER', "Lockdown, Lockdown, Lockdown.\nSuchen Sie das nächstgelegene Gebäude auf."],
            'STINTRUDER' => ['SIRENENTEST', "Es besteht kein Handlungsbedarf.\n\nLockdown, Lockdown, Lockdown.\nSuchen Sie das nächstgelegene Gebäude auf."],
            'EINTRUDER' => ['EXERCISE', "Es besteht Handlungsbedarf.\n\nLockdown, Lockdown, Lockdown.\nSuchen Sie das nächstgelegene Gebäude auf."]
        ];

        if (isset($alarmTypes[$_POST['alarmType']])) {
            [$alarmType, $alarmMessage] = $alarmTypes[$_POST['alarmType']];

            updateDBEntry('SystemOptions', 'Option', 'AlarmType', 'Value', $alarmType);
            updateDBEntry('SystemOptions', 'Option', 'AlarmMessage', 'Value', $alarmMessage);
            updateDBEntry('SystemOptions', 'Option', 'AlarmStatus', 'Value', 'true');

            addAuditLog($_SESSION['Username'], 'Alarm', 'Alarmierung aktiviert');
            createSessionAlert("", "Alarm wurde ausgelöst", "success", "false", "2000");
            header('Location: /terminal/console?id=' . $_GET['id']);
            exit;
        }
    }
}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0 text-uppercase"><?php echo getZoneDetails($_GET['id'], 'ZoneName'); ?></h4>
        <span class="text-secondary">Terminal</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap">

        <?php if (getZoneDetails($_GET['id'], 'AlarmAuthorisation') == '1'): ?>
            <form action="" method="post" style="margin: 0; padding: 0;">
                <button id="alarmOn" style="display: none;" name="setAlarmOff"
                    class="btn btn-warning text-white btn-icon-text mb-md-0 me-2">
                    <i class="btn-icon-prepend mdi mdi-bell-ring"></i> Deaktivieren
                </button>

                <button type="button" id="alarmOff" style="display: none;" name="setAlarmOn"
                    class="btn btn-danger btn-icon-text mb-md-0 me-2" data-bs-toggle="modal" data-bs-target="#modalAlarm">
                    <i class="btn-icon-prepend mdi mdi-bell-off"></i> Alarm
                </button>
            </form>
        <?php endif; ?>


        <button id="dataPrivacy" class="btn btn-primary btn-icon mb-md-0 me-2" data-bs-toggle="tooltip"
            data-bs-placement="top" title="Datenschutzmodus"><i
                class="mdi <?php echo (isset($_COOKIE['dataPrivacy']) && $_COOKIE['dataPrivacy'] === 'true') ? 'mdi-eye-outline' : 'mdi-eye-off-outline'; ?>"></i>
        </button>

        <a href="/terminal/login?console=logout" class="btn btn-secondary btn-icon mb-md-0" data-bs-toggle="tooltip"
            data-bs-placement="top" title="Verlassen">
            <i class="mdi mdi-logout"></i>
        </a>
    </div>
</div>

<div class="row">

    <div class="col-12 col-md-4 col-xl-3 grid-margin">

        <div class="card" style="position: sticky; top:100px;">
            <form id="zoneForm" style="margin: 0; padding: 0;">
                <div class="input-group">
                    <input type="text" id="inputAccessCard" name="inputAccessCard" class="form-control"
                        placeholder="Zutrittskarte" aria-label="Zutrittskarte" aria-describedby="Zutrittskarte"
                        autofocus>
                    <input type="hidden" id="zoneID" name="zoneID" value="<?php echo htmlspecialchars($_GET['id']); ?>">
                    <button type="button" class="btn btn-primary btn-icon"><i class="mdi mdi-barcode-scan"></i></button>
                </div>
            </form>
        </div>

        <div id="responseMessage"></div>

    </div>

    <div class="col-12 col-md-8 col-xl-9 grid-margin">
        <div class="card">

            <div class="card-header">
                <ul class="nav nav-tabs card-header-tabs" id="lineTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="home-line-tab" data-bs-toggle="tab" href="#currentZone"
                            role="tab" aria-controls="Aktuelle Zone" aria-selected="true">Aktuelle Zone</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="profile-line-tab" data-bs-toggle="tab" href="#allZones" role="tab"
                            aria-controls="Alle" aria-selected="false">Alle</a>
                    </li>
                </ul>
            </div>

            <div class="card-body">

                <div class="tab-content" id="lineTabContent">

                    <div class="tab-pane show active" id="currentZone" role="tabpanel" aria-labelledby="home-line-tab">

                        <div id="dataCurrentZone">
                            <div class="alert alert-primary mb-0" role="alert">
                                <i class="mdi mdi-timer-sand-complete"></i>
                                Die Daten werden geladen.
                            </div>
                        </div>

                    </div>



                    <div class="tab-pane" id="allZones" role="tabpanel" aria-labelledby="home-line-tab">

                        <div id="dataAllZones">
                            <div class="alert alert-primary mb-0" role="alert">
                                <i class="mdi mdi-timer-sand-complete"></i>
                                Die Daten werden geladen.
                            </div>
                        </div>

                    </div>

                </div>

            </div>
        </div>
    </div>

</div>

<!-- Modal : Alarm -->
<div class="modal fade" id="modalAlarm" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form action="" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Alarm</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-warning mb-4" role="alert">
                        Die Aktivierung der Alarmierung führt dazu, dass die Alarmmeldung <strong>sofort auf allen
                            eingeschalteten Computern</strong> erscheint.
                        Jede Auslösung der Alarmierung wird <strong>protokolliert</strong> und kann nachverfolgt werden.
                        Bitte setzen Sie die Alarmfunktion <strong>verantwortungsvoll</strong> ein.
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Art</label>
                                <select class="form-select" name="alarmType" data-width="100%">
                                    <option value="IDF">IDF</option>
                                    <option value="INTRUDER">INTRUDER</option>
                                    <option value="STIDF">SIRENENTEST IDF</option>
                                    <option value="STINTRUDER">SIRENENTEST INTRUDER</option>
                                    <option value="EIDF">EXERCISE IDF</option>
                                    <option value="EINTRUDER">EXERCISE INTRUDER</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
                    <button type="submit" class="btn btn-icon-text btn-danger" name="setAlarm">
                        <i class="btn-icon-prepend mdi mdi-bell-ring"></i>
                        Alarmieren
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Letzten aktiven Tab aus dem Local Storage laden
        var consoleActiveTab = localStorage.getItem('consoleActiveTab');
        if (consoleActiveTab) {
            var tabTrigger = new bootstrap.Tab(document.querySelector('a[href="' + consoleActiveTab + '"]'));
            tabTrigger.show();
        }

        // Event Listener für Tab Wechsel hinzufügen und im Local Storage speichern
        var tabLinks = document.querySelectorAll('a[data-bs-toggle="tab"]');
        tabLinks.forEach(function (tab) {
            tab.addEventListener('shown.bs.tab', function (event) {
                localStorage.setItem('consoleActiveTab', event.target.getAttribute('href'));
            });
        });
    });

    // Focus immer auf das Eingabefeld setzen
    function setFocus() {
        document.getElementById('inputAccessCard').focus();
    }
    document.getElementById('inputAccessCard').addEventListener('blur', setFocus);

    // Zonendaten Laden
    function updateContent() {
        $.ajax({
            url: "/terminal/zone.current.inc?id=<?php echo $_GET['id']; ?>", // Pfad zur Datei oder URL, die Daten liefert
            success: function (result) {
                $("#dataCurrentZone").html(result); // Bereich mit neuen Daten aktualisieren
            }
        });

        $.ajax({
            url: "/terminal/zone.all.inc?id=<?php echo $_GET['id']; ?>", // Pfad zur Datei oder URL, die Daten liefert
            success: function (result) {
                $("#dataAllZones").html(result); // Bereich mit neuen Daten aktualisieren
            }
        });
    }
    setInterval(updateContent, 2000);

    // Buchung
    $(document).ready(function () {
        $('#zoneForm').on('submit', function (event) {
            event.preventDefault(); // Verhindert das Neuladen der Seite

            $.ajax({
                url: '/terminal/console.function.php', // PHP-Datei, die die Anfrage bearbeitet
                type: 'POST',
                data: $(this).serialize(), // Serialisiert die Formulardaten
                dataType: 'json',
                success: function (response) {
                    // SweetAlert mit dynamischen Inhalten basierend auf JSON-Antwort anzeigen
                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        text: response.message,
                        html: response.html,
                        footer: response.footer,
                        timer: 4000,
                        timerProgressBar: true,
                        showConfirmButton: false
                    });
                    // Eingabefeld leeren
                    $('#inputAccessCard').val('');
                },
                error: function () {
                    Swal.fire({
                        icon: 'error',
                        title: 'Fehler',
                        text: 'Fehler bei der Anfrage. Bitte versuchen Sie es erneut.',
                        timer: 3000,
                        timerProgressBar: true,
                        showConfirmButton: false
                    });
                    // Eingabefeld leeren
                    $('#inputAccessCard').val('');
                }
            });
        });
    });

    // Datenschutzmodus
    document.getElementById("dataPrivacy").addEventListener("click", () => {
        const cookieName = "dataPrivacy";
        const cookieExists = document.cookie.split(';').some((item) => item.trim().startsWith(cookieName + '='));
        const iconElement = document.querySelector("#dataPrivacy .mdi");

        if (cookieExists) {
            // Cookie existiert -> löschen und Icon wechseln
            document.cookie = cookieName + "=; path=/; expires=Thu, 01 Jan 1970 00:00:00 GMT";
            iconElement.classList.remove("mdi-eye-outline");
            iconElement.classList.add("mdi-eye-off-outline");
        } else {
            // Cookie existiert nicht -> setzen und Icon wechseln
            document.cookie = cookieName + "=true; path=/; expires=" + new Date(Date.now() + 365 * 24 * 60 * 60 * 1000).toUTCString();
            iconElement.classList.remove("mdi-eye-off-outline");
            iconElement.classList.add("mdi-eye-outline");
        }
    });

    // AlarmStatus
    function checkAlarmStatus() {
        $.ajax({
            url: '/api?api=alarm',
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                let isActive = response.status === "true";
                $("#alarmOn").toggle(isActive);
                $("#alarmOff").toggle(!isActive);
            }
        });
    }

    $(document).ready(function () {
        checkAlarmStatus();
        setInterval(checkAlarmStatus, 5000);
    });

</script>